/*
 * Copyright (C) 2016 Renfell Engineering Pty Ltd - All Rights Reserved
 *
 * Use of this work is subject to license and solely for use with hardware
 * supplied by Renfell Engineering Pty Ltd.
 *
 * Proprietary and confidential.
 * This file or any part thereof may not be used, distributed, copied, or
 * modified for use for any purpose other than that for which it was
 * originally provided without first receiving written permission of the
 * copyright holder.
 *
 * This source code is provided 'as is' without warranty of any kind, either
 * expressed or implied by consumer legislation or otherwise, including but
 * not limited to the implied warranties of merchantability and/or fitness
 * for a particular purpose.
 *
 * The end user acknowledges that this software is a "work in progress", and
 * as such should not be relied upon in a commercial environment or other
 * situations where economic loss or harm to persons may arise due to a
 * failure to perform to the end users specific requirements.
 *
 * By use of this software you agree to the use of the above terms.
 *
 */

#include "legato.h"
#include "interfaces.h"	/* include auto-generated api interfaces from Component.cdef */

/*
 * All I/O based around using IoT Slot 1 (the middle one) on mangOH Green board
 */

#define GPIOIOTSLOT RE_MANGOH_DEFS_IOT_1

/*
 *
 * NOTE: IoT1_GPIO1 is 'created' as an instance of le_gpio using requires: api: stanza in Component.cdef
 *
 */

/*
 * Timer Handler to toggle the GPIO
 */
void blinkTimerHandler(le_timer_Ref_t pTimerRef )
{
	le_result_t   result = LE_OK;
	static uint8_t state = 0;			// static variable to hold state of GPIO


	if (state) { result = IoT1_GPIO1_Activate();   state = 0; }
	else       { result = IoT1_GPIO1_Deactivate(); state = 1; }

	if ( result != LE_OK )
		LE_INFO( "Timer: GPIO returns [%d]", result );

	LE_INFO( "state= [%s]", ((state)?"HI":"LO") );

	le_timer_Restart( pTimerRef );		// restart the timer

    return;
}


COMPONENT_INIT
{
	le_result_t result = LE_OK;

    LE_INFO( "gpioBlinkyComponent Init" );

    // ensure that IoT slot 1 is 'Enabled' using the re_mangOH iot service

    re_mangoh_iot_Enable( GPIOIOTSLOT );

    // configure blinky GPIO - use IoT slot 1, GPIO1 (WP85 pin GPIO25)

    // may need le_gpio_ConnectService() here - but should be called automatically...

    result = IoT1_GPIO1_SetPushPullOutput( IOT1_GPIO1_ACTIVE_HIGH, true ); // constant renamed from LE_GPIO_ACTIVE_HIGH via binding
    if ( result != LE_OK )
    {
    	LE_INFO("SetPushPullOutput returned [%d]", result );
    }

    // set up timer to blink GPIO (roughly) every 500 milliseconds

    le_timer_Ref_t blinkTimer = le_timer_Create("BlinkTimer");
    le_clk_Time_t blinkClkTime;

    blinkClkTime.sec = 0; blinkClkTime.usec = (500*1000);
    le_timer_SetHandler ( blinkTimer, blinkTimerHandler );
    le_timer_SetInterval( blinkTimer, blinkClkTime );
    le_timer_Start( blinkTimer );

}

