/**
 * Copyright (C) 2017 Renfell Engineering Pty Ltd - All Rights Reserved
 *
 * Use of this work is subject to license and solely for use with hardware
 * supplied by Renfell Engineering Pty Ltd.
 *
 * Proprietary and confidential.
 * This file or any part thereof may not be used, distributed, copied, or
 * modified for use for any purpose other than that for which it was
 * originally provided without first receiving written permission of the
 * copyright holder.
 *
 * This source code is provided 'as is' without warranty of any kind, either
 * expressed or implied by consumer legislation or otherwise, including but
 * not limited to the implied warranties of merchantability and/or fitness
 * for a particular purpose.
 *
 * The end user acknowledges that this software is a "work in progress", and
 * as such should not be relied upon in a commercial environment or other
 * situations where economic loss or harm to persons may arise due to a
 * failure to perform to the end users specific requirements.
 *
 * By use of this software you agree to the use of the above terms.
 *
 */

/**
 * Simple Arduino Slave for the mangOH green DV3/DV4 board
 *
 * This application:
 *  sets up the serial port for 57600 baud
 *  Waits for a character to be available on the Serial port and:
 *    if the char is '\r', \n' or ' ' - add the character to a string
 *    if the char is 'numeric' - add the character to a string
 *    if the character is 'alpha' - invert the char by XOR and add to a string
 *  if the string is not empty, print the string on teh serial port
 *
 * Requirements:
 *  Sierra Wireless MangOH DV3 or DV3 board with legato V16.10.1 installed
 *   or a Arduino Leonardo for testing
 *   
 */


void processChar(char pChar, char *pMsg)
{
    if (( '\r' == pChar ) || ('\n' == pChar ) || (' ' == pChar) )
    {                         // special chars
      sprintf(pMsg, "%c", pChar);
    }
    else if ( isDigit(pChar) )
    {                         // digits
      sprintf(pMsg, "%c", pChar);
    }
    else if ( isAlpha(pChar) )
    {                         // A-Z or a-z
      pChar = pChar ^ 0x20; // invert by xor'ing bit 5
      sprintf(pMsg, "%c", pChar);
    }
}

void setup()
{
  Serial.begin(57600);         // set up CDC (USB) serial port for 57600 baud.
  Serial1.begin(57600);        // set up Hardware (TX/RX) serial port for 57600 baud.
}

void loop() 
{

  if ( Serial.available() )   // wait for character to be available on the USB serial port
  {
    int inChar;
    char str[10] = { 0 };
    inChar = Serial.read();   // read one character

    processChar(inChar, str);

    if (strlen(str) > 0 )
    {
      Serial.print(str);
    }
    delay(1);
  }

  
  if ( Serial1.available() )   // wait for character to be available on the Hardware serial port
  {
    int inChar;
    char str[10] = { 0 };
    inChar = Serial1.read();   // read one character

    processChar(inChar, str);

    if (strlen(str) > 0 )
    {
      Serial1.print(str);
    }
    delay(1);
  }
}
